#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// The OctopusMod01.fsh  by  HyPeRbLaH
//https://www.shadertoy.com/view/sllczs
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 mul(vec2 a, vec2 b) {
    return vec2(a.x * b.x - a.y * b.y, a.x * b.y + a.y * b.x);
}

vec3 fz(vec2 p) {
    float th = iTime * 0.025 + 8.0;
    
    vec2 z = p;
    vec2 c = vec2(cos(th), sin(th)) * sin(th * 0.03893827372837823) * 0.75;
    
    vec2 avg = vec2(0);
    
    float i = 0.0;
    while (i < 100.0 && length(z) < 4.0) {
        ++i;
        vec2 b = z;
        z = mul(z, z) + c;
        c = b;
        avg += z;
    }
    return vec3(avg / (i + 1.0), i);
}

float rs(float v, float on, float ox, float nn, float nx) {
    return (v - on) * (nx - nn) / (ox - on) + nn;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float scale = 0.5;

    float size = min(iResolution.x, iResolution.y);
    vec2 uv = (fragCoord - iResolution.xy * 0.5)/size * scale;
    
    float th = -iTime * 0.05;
    float th2 = iTime * 0.75;
    uv += vec2(cos(th), sin(th)) * 0.05;
    
    vec3 avg = vec3(0);

    float aa = 4.0;
    for (float i = 0.0; i < aa; ++i) {
        float a = 6.283 * i / aa + iTime;
        vec3 v = fz(uv + vec2(cos(a), sin(a)) / size * scale * 0.333);
        v.z = pow(v.z, 0.125);
        v = normalize(v);
        avg += v;
    }
    
    vec3 v = avg / aa;
    
    float s1 = 5.01;
    float s2 = 4.24;
    vec3 rl = normalize(vec3(cos(th2) * s1, sin(th2) * s1, 5.0));
    vec3 gl = normalize(vec3(cos(th2 + 0.79) * s2, sin(th2 + 0.79) * s2, 5.5));
    vec3 bl = normalize(vec3(cos(th2 + 1.57) * s1, sin(th2 + 1.57) * s1, 5.0));
    
    vec3 col = vec3(dot(v, rl), dot(v, gl), dot(v, bl));

    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

